/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.ValidationCallback;
import java.io.WriteAbortedException;
import java.util.Vector;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private InputStream in;
    private int count;
    private boolean blockDataMode;
    private byte[] buffer;
    private DataInputStream dis;
    private IOException abortIOException;
    private ClassNotFoundException abortClassNotFoundException;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Class currentClass;
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private Vector wireHandle2Object;
    private int nextWireOffset;
    private Vector callbacks;
    private int recursionDepth;
    private byte currCode;
    private boolean enableResolve;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.in = inputStream;
        this.dis = new DataInputStream(this);
        this.readStreamHeader();
        this.resetStream();
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        ClassNotFoundException classNotFoundException;
        int n;
        if (this.blockDataMode && (n = this.available()) > 0) {
            throw new OptionalDataException(n);
        }
        this.peekCode();
        Object object = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        boolean bl = this.setBlockData(false);
        ++this.recursionDepth;
        Object object2 = null;
        byte by = this.readCode();
        try {
            block37: {
                try {
                    int n2 = -1;
                    switch (by) {
                        case 112: {
                            object2 = null;
                            break;
                        }
                        case 113: {
                            n2 = this.readInt() - 0x7E0000;
                            try {
                                object2 = this.wireHandle2Object.elementAt(n2);
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw new StreamCorruptedException("Reference to object never serialized.");
                            }
                        }
                        case 116: {
                            object2 = this.readUTF();
                            this.assignWireOffset(object2);
                            break;
                        }
                        case 118: {
                            ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
                            if (objectStreamClass2 == null) {
                                throw new StreamCorruptedException("Class not in stream");
                            }
                            object2 = objectStreamClass2.forClass();
                            if (object2 == null) {
                                throw new ClassNotFoundException(objectStreamClass2.getName());
                            }
                            this.assignWireOffset(object2);
                            break;
                        }
                        case 114: {
                            object2 = this.inputClassDescriptor();
                            break;
                        }
                        case 117: {
                            object2 = this.inputArray();
                            break;
                        }
                        case 115: {
                            n2 = this.inputObject();
                            object2 = this.currentObject;
                            if (this.enableResolve) {
                                object2 = this.resolveObject(object2);
                                this.wireHandle2Object.setElementAt(object2, n2);
                            }
                            break;
                        }
                        case 120: {
                            if (!bl) {
                                throw new StreamCorruptedException("Unexpected end of block data");
                            }
                            this.pushbackCode((byte)120);
                            this.count = -1;
                            throw new OptionalDataException(true);
                        }
                        case 119: 
                        case 122: {
                            if (by == 122) {
                                int n3;
                                int n4;
                                int n5;
                                int n6 = this.in.read();
                                if ((n6 | (n5 = this.in.read()) | (n4 = this.in.read()) | (n3 = this.in.read())) < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                                this.count = n6 << 24 | n5 << 16 | n4 << 8 | n3;
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("Negative block data size");
                                }
                            } else {
                                this.count = this.in.read();
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                            }
                            if (!bl) {
                                throw new StreamCorruptedException("Unexpected blockdata");
                            }
                            throw new OptionalDataException(this.count);
                        }
                        case 123: {
                            this.resetStream();
                            IOException iOException = (IOException)this.readObject();
                            this.resetStream();
                            throw new WriteAbortedException("Writing aborted by exception", iOException);
                        }
                        default: {
                            throw new StreamCorruptedException("Unknown code in readObject " + by);
                        }
                    }
                }
                catch (OptionalDataException optionalDataException) {
                    throw optionalDataException;
                }
                catch (IOException iOException) {
                    if (this.abortIOException == null && this.abortClassNotFoundException == null) {
                        this.abortIOException = iOException;
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (this.abortIOException != null || this.abortClassNotFoundException != null) break block37;
                    this.abortClassNotFoundException = classNotFoundException2;
                }
            }
            classNotFoundException = null;
            --this.recursionDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            --this.recursionDepth;
            this.currentObject = object;
            this.currentClassDesc = objectStreamClass;
            this.setBlockData(bl);
            throw throwable;
        }
        this.setBlockData(bl);
        IOException iOException = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            throw iOException;
        }
        classNotFoundException = this.abortClassNotFoundException;
        if (this.recursionDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        if (this.recursionDepth == 0) {
            this.doValidations();
        }
        return object2;
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        if (this.currentClassDesc.getFieldSequence() != null) {
            boolean bl = this.setBlockData(false);
            this.inputClassFields(this.currentObject, this.currentClass, this.currentClassDesc.getFieldSequence());
            this.setBlockData(bl);
        }
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        ValidationCallback validationCallback = new ValidationCallback(objectInputValidation, n);
        if (this.callbacks == null) {
            this.callbacks = new Vector(100, 100);
        }
        if (this.callbacks.isEmpty() || ((ValidationCallback)this.callbacks.lastElement()).priority >= n) {
            this.callbacks.addElement(validationCallback);
            return;
        }
        int n2 = this.callbacks.size();
        int n3 = 0;
        while (n3 < n2) {
            ValidationCallback validationCallback2 = (ValidationCallback)this.callbacks.elementAt(n3);
            if (validationCallback2.priority <= n) {
                this.callbacks.insertElementAt(validationCallback, n3);
                return;
            }
            ++n3;
        }
    }

    private void doValidations() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        int n = this.callbacks.size();
        int n2 = 0;
        while (n2 < n) {
            ValidationCallback validationCallback = (ValidationCallback)this.callbacks.elementAt(n2);
            validationCallback.callback.validateObject();
            ++n2;
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.loadClass0(null, objectStreamClass.getName());
    }

    private native Class loadClass0(Class var1, String var2) throws ClassNotFoundException;

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected final boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableResolve;
        if (bl) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                this.enableResolve = true;
                return bl2;
            }
            throw new SecurityException("Not trusted class");
        }
        this.enableResolve = false;
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.readShort();
        short s2 = this.readShort();
        if (s != -21267) {
            throw new StreamCorruptedException("InputStream does not contain a serialized object");
        }
        if (s2 != 5) {
            throw new StreamCorruptedException("Version Mismatch, Expected " + 5 + " and got " + s2);
        }
    }

    private ObjectStreamClass inputClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class clazz;
        String string = this.readUTF();
        long l = this.readLong();
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l);
        this.assignWireOffset(objectStreamClass);
        objectStreamClass.read(this);
        boolean bl = this.setBlockData(true);
        try {
            clazz = this.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        this.SkipToEndOfBlockData();
        bl = this.setBlockData(bl);
        objectStreamClass.setClass(clazz);
        ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
        objectStreamClass.setSuperclass(objectStreamClass2);
        return objectStreamClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object inputArray() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
        Class clazz = objectStreamClass.forClass();
        if (clazz == null) {
            throw new ClassNotFoundException(objectStreamClass.getName());
        }
        int n = this.readInt();
        this.currentObject = ObjectInputStream.allocateNewArray(clazz, n);
        this.assignWireOffset(this.currentObject);
        Class clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            if (this.buffer == null) {
                this.buffer = new byte[1024];
            }
            int n2 = this.buffer.length;
            int n3 = this.buffer.length;
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])this.currentObject;
                int n4 = 0;
                while (n4 < n) {
                    if (n2 >= n3) {
                        int n5 = Math.min(n - n4, n3);
                        this.readFully(this.buffer, 0, n5);
                        n2 = 0;
                    }
                    blArray[n4] = this.buffer[n2] != 0;
                    ++n2;
                    ++n4;
                }
                return this.currentObject;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])this.currentObject;
                this.readFully(byArray, 0, n);
                return this.currentObject;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])this.currentObject;
                int n6 = 0;
                while (n6 < n) {
                    if (n2 > n3 - 2) {
                        int n7 = Math.min((n - n6) * 2, n3);
                        this.readFully(this.buffer, 0, n7);
                        n2 = 0;
                    }
                    sArray[n6] = (short)(((this.buffer[n2] & 0xFF) << 8) + (this.buffer[n2 + 1] & 0xFF));
                    n2 += 2;
                    ++n6;
                }
                return this.currentObject;
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])this.currentObject;
                int n8 = 0;
                while (n8 < n) {
                    if (n2 > n3 - 4) {
                        int n9 = Math.min((n - n8) * 4, n3);
                        this.readFully(this.buffer, 0, n9);
                        n2 = 0;
                    }
                    nArray[n8] = ((this.buffer[n2] & 0xFF) << 24) + ((this.buffer[n2 + 1] & 0xFF) << 16) + ((this.buffer[n2 + 2] & 0xFF) << 8) + (this.buffer[n2 + 3] & 0xFF);
                    n2 += 4;
                    ++n8;
                }
                return this.currentObject;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])this.currentObject;
                int n10 = 0;
                while (n10 < n) {
                    int n11;
                    if (n2 > n3 - 8) {
                        n11 = Math.min((n - n10) * 8, n3);
                        this.readFully(this.buffer, 0, n11);
                        n2 = 0;
                    }
                    n11 = ((this.buffer[n2] & 0xFF) << 24) + ((this.buffer[n2 + 1] & 0xFF) << 16) + ((this.buffer[n2 + 2] & 0xFF) << 8) + (this.buffer[n2 + 3] & 0xFF);
                    int n12 = ((this.buffer[n2 + 4] & 0xFF) << 24) + ((this.buffer[n2 + 5] & 0xFF) << 16) + ((this.buffer[n2 + 6] & 0xFF) << 8) + (this.buffer[n2 + 7] & 0xFF);
                    lArray[n10] = ((long)n11 << 32) + ((long)n12 & 0xFFFFFFFFL);
                    n2 += 8;
                    ++n10;
                }
                return this.currentObject;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])this.currentObject;
                int n13 = 0;
                while (n13 < n) {
                    int n14;
                    if (n2 > n3 - 4) {
                        n14 = Math.min((n - n13) * 4, n3);
                        this.readFully(this.buffer, 0, n14);
                        n2 = 0;
                    }
                    n14 = ((this.buffer[n2] & 0xFF) << 24) + ((this.buffer[n2 + 1] & 0xFF) << 16) + ((this.buffer[n2 + 2] & 0xFF) << 8) + (this.buffer[n2 + 3] & 0xFF);
                    n2 += 4;
                    fArray[n13] = Float.intBitsToFloat(n14);
                    ++n13;
                }
                return this.currentObject;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])this.currentObject;
                int n15 = 0;
                while (n15 < n) {
                    int n16;
                    if (n2 > n3 - 8) {
                        n16 = Math.min((n - n15) * 8, n3);
                        this.readFully(this.buffer, 0, n16);
                        n2 = 0;
                    }
                    n16 = ((this.buffer[n2] & 0xFF) << 24) + ((this.buffer[n2 + 1] & 0xFF) << 16) + ((this.buffer[n2 + 2] & 0xFF) << 8) + (this.buffer[n2 + 3] & 0xFF);
                    int n17 = ((this.buffer[n2 + 4] & 0xFF) << 24) + ((this.buffer[n2 + 5] & 0xFF) << 16) + ((this.buffer[n2 + 6] & 0xFF) << 8) + (this.buffer[n2 + 7] & 0xFF);
                    n2 += 8;
                    dArray[n15] = Double.longBitsToDouble(((long)n16 << 32) + ((long)n17 & 0xFFFFFFFFL));
                    ++n15;
                }
                return this.currentObject;
            } else {
                if (clazz2 != Character.TYPE) throw new InvalidClassException(clazz.getName());
                char[] cArray = (char[])this.currentObject;
                int n18 = 0;
                while (n18 < n) {
                    if (n2 > n3 - 2) {
                        int n19 = Math.min((n - n18) * 2, n3);
                        this.readFully(this.buffer, 0, n19);
                        n2 = 0;
                    }
                    cArray[n18] = (char)(((this.buffer[n2] & 0xFF) << 8) + (this.buffer[n2 + 1] & 0xFF));
                    n2 += 2;
                    ++n18;
                }
            }
            return this.currentObject;
        } else {
            Object[] objectArray = (Object[])this.currentObject;
            int n20 = 0;
            while (n20 < n) {
                objectArray[n20] = this.readObject();
                ++n20;
            }
        }
        return this.currentObject;
    }

    private int inputObject() throws IOException, ClassNotFoundException {
        Class clazz;
        int n = -1;
        this.currentClassDesc = (ObjectStreamClass)this.readObject();
        this.currentClass = this.currentClassDesc.forClass();
        if (this.currentClass == null) {
            throw new ClassNotFoundException(this.currentClassDesc.getName());
        }
        if (this.currentClassDesc.isExternalizable()) {
            try {
                this.currentObject = ObjectInputStream.allocateNewObject(this.currentClass, this.currentClass);
                n = this.assignWireOffset(this.currentObject);
                Externalizable externalizable = (Externalizable)this.currentObject;
                externalizable.readExternal(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
            }
        }
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        Class clazz2 = this.currentClass;
        int n2 = this.spClass;
        objectStreamClass = this.currentClassDesc;
        clazz2 = this.currentClass;
        while (objectStreamClass != null) {
            Class clazz3 = objectStreamClass.forClass();
            clazz = clazz2;
            while (clazz != null) {
                if (clazz3 == clazz) break;
                clazz = clazz.getSuperclass();
            }
            ++this.spClass;
            if (this.spClass >= this.classes.length) {
                int bl = this.classes.length * 2;
                Class[] classArray = new Class[bl];
                ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[bl];
                System.arraycopy(this.classes, 0, classArray, 0, this.classes.length);
                System.arraycopy(this.classdesc, 0, objectStreamClassArray, 0, this.classes.length);
                this.classes = classArray;
                this.classdesc = objectStreamClassArray;
            }
            if (clazz == null) {
                this.classdesc[this.spClass] = objectStreamClass;
                this.classes[this.spClass] = null;
            } else {
                this.classdesc[this.spClass] = objectStreamClass;
                this.classes[this.spClass] = clazz;
                clazz2 = clazz.getSuperclass();
            }
            objectStreamClass = objectStreamClass.getSuperclass();
        }
        try {
            this.currentObject = ObjectInputStream.allocateNewObject(this.currentClass, clazz2);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new InvalidClassException(clazz2.getName(), "NoSuchMethodError");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidClassException(clazz2.getName(), "IllegalAccessException");
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidClassException(clazz2.getName(), "InstantiationException");
        }
        n = this.assignWireOffset(this.currentObject);
        try {
            this.spClass = this.spClass;
            while (this.spClass > n2) {
                this.currentClassDesc = this.classdesc[this.spClass];
                this.currentClass = this.classes[this.spClass];
                if (this.classes[this.spClass] != null) {
                    this.setBlockData(true);
                    this.currentClassDesc.localClassDescriptor();
                    if (!this.invokeObjectReader(this.currentObject, this.currentClass)) {
                        this.defaultReadObject();
                    }
                } else if (this.currentClassDesc.getFieldSequence() != null) {
                    boolean bl = this.setBlockData(false);
                    this.inputClassFields(null, this.currentClass, this.currentClassDesc.getFieldSequence());
                    this.setBlockData(bl);
                }
                if (this.currentClassDesc.hasWriteObject()) {
                    this.SkipToEndOfBlockData();
                }
                this.setBlockData(false);
                --this.spClass;
            }
        }
        finally {
            clazz = null;
            this.spClass = n2;
        }
        return n;
    }

    private void SkipToEndOfBlockData() throws IOException, ClassNotFoundException {
        while (this.peekCode() != 120) {
            try {
                this.readObject();
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.length <= 0) continue;
                this.skip(optionalDataException.length);
            }
        }
        this.readCode();
    }

    private void resetStream() throws IOException {
        this.wireHandle2Object = new Vector(100, 100);
        this.nextWireOffset = 0;
        this.classes = new Class[20];
        this.classdesc = new ObjectStreamClass[20];
        this.spClass = 0;
        this.setBlockData(true);
        this.callbacks = null;
    }

    private int assignWireOffset(Object object) throws IOException {
        this.wireHandle2Object.addElement(object);
        if (++this.nextWireOffset != this.wireHandle2Object.size()) {
            throw new StreamCorruptedException("Elements not assigned in order");
        }
        return this.nextWireOffset - 1;
    }

    private byte peekCode() throws IOException, StreamCorruptedException {
        while (this.currCode == 0) {
            int n = this.in.read();
            if (n < 0) {
                throw new EOFException("Expecting code");
            }
            this.currCode = (byte)n;
            if (this.currCode < 112 || this.currCode > 123) {
                throw new StreamCorruptedException("Type code out of range, is " + this.currCode);
            }
            if (this.currCode != 121) continue;
            if (this.recursionDepth != 0 || this.currentObject != null || this.currentClassDesc != null) {
                throw new StreamCorruptedException("Illegal stream state for reset");
            }
            this.resetStream();
            this.currCode = 0;
        }
        return this.currCode;
    }

    private byte readCode() throws IOException, StreamCorruptedException {
        byte by = this.peekCode();
        this.currCode = 0;
        return by;
    }

    private void pushbackCode(byte by) {
        this.currCode = by;
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        if (this.blockDataMode && this.count > 0) {
            throw new StreamCorruptedException("Unread data");
        }
        this.count = bl ? 0 : -1;
        this.blockDataMode = bl;
        return !bl;
    }

    public int read() throws IOException {
        int n;
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            n = this.in.read();
            if (n >= 0) {
                --this.count;
            }
        } else {
            n = this.in.read();
        }
        return n;
    }

    private void refill() throws IOException {
        byte by;
        this.count = -1;
        try {
            by = this.peekCode();
        }
        catch (EOFException eOFException) {
            return;
        }
        if (by == 119) {
            by = this.readCode();
            int n = this.in.read();
            if (n < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            this.count = n & 0xFF;
            return;
        }
        if (by == 122) {
            int n;
            int n2;
            int n3;
            by = this.readCode();
            int n4 = this.in.read();
            if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n;
            if (n5 < 0) {
                throw new StreamCorruptedException("Negative block data size");
            }
            this.count = n5;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            int n3 = Math.min(n2, this.count);
            int n4 = this.in.read(byArray, n, n3);
            if (n4 > 0) {
                this.count -= n4;
            }
            return n4;
        }
        return this.in.read(byArray, n, n2);
    }

    public int available() throws IOException {
        if (this.blockDataMode) {
            if (this.count == 0 && this.in.available() > 0) {
                this.refill();
            }
            if (this.count >= 0) {
                return this.count;
            }
            return 0;
        }
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dis.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    private native void inputClassFields(Object var1, Class var2, int[] var3) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;

    private static native Object allocateNewObject(Class var0, Class var1) throws InstantiationException, IllegalAccessException;

    private static native Object allocateNewArray(Class var0, int var1);

    private native boolean invokeObjectReader(Object var1, Class var2) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException;
}

